/* FILE: merror.h                               (D. Tottingham  02/23/91)

This is an include file of defines, data structure definitions and
external declarations that are common in the merror module.

*/

#ifndef _MERROR_
#define _MERROR_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"


/************************************************************************
                          STRUCTURE DEFINITIONS


************************************************************************/
typedef struct {
        unsigned int id;
        char * text;
        FLAG memory_dump;
        FLAG to_logfile;
} ER_MESSAGE;


/************************************************************************
                                DEFINES

************************************************************************/
#define UNEXPECTED_ERROR        0

#define DM_NO_STORAGE           100
#define DSP_INVALID_FILE        101
#define DSP_NO_BOARD            102
#define DT_FREQTOOHIGH          103
#define DT_FREQTOOLOW           104
#define DT_INVALID_BUFFERSIZE   105
#define DT_INVALID_CHANNEL      106
#define DT_INVALID_CHANNELSIZE  107
#define DT_INVALID_GAIN         108
#define DT_INVALID_MUX          109
#define DT_INVALID_SCANCOUNT    110
#define DT_IO_NOTINPROG         111
#define DT_NO_ATLDRV            112
#define DT_NO_BOARD             113
#define DT_NO_STATIONS          114
#define DT_NO_STORAGE           115
#define DT_OVERFLOW             116
#define DT_TIMEOUT              117
#define DT_UNAVAILABLE_XB       118
#define F_DISK_FULL             119
#define F_INVALID_DRIVE         120
#define F_NO_STORAGE            121
#define HS_NO_STORAGE           122
#define L_NO_STORAGE            123
#define O_DISK_FULL             124
#define O_INVALID_DRIVE         125
#define O_INVALID_LOGFILE       126
#define PK_NO_STORAGE           127
#define Q_NO_STORAGE            128
#define S_NO_STORAGE            129
#define SP_INVALID_SIZE         130
#define SP_NO_BOARD             131
#define SP_NO_STORAGE           132
#define ST_INVALID_FILE         133
#define ST_NO_STORAGE           134
#define U_NO_STORAGE            135
#define T_INVALID_CHANNEL       136
#define T_INVALID_LTASIZE       137
#define T_INVALID_STASIZE       138
#define T_NO_STORAGE            139
#define X_INVALID_INPUTFILE     140
#define DM_POWRSTOR             141
#define DM_POWRSTOR_1           142
#define DM_POWRSTOR_2           143
#define DM_POWRSTOR_3           144
#define DM_POWRSTOR_4           145
#define DM_POWRSTOR_5           146
#define DM_POWRSTOR_6           147
#define DM_POWRSTOR_7           148
#define DM_POWRSTOR_8           149
#define DM_POWRSTOR_9           150
#define DM_POWRSTOR_10          151
#define DM_POWRSTOR_11          152


/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC void er_abort (unsigned int);


#endif
